unit IWCompButton;

{PUBDIST}

interface

uses
  {$IFDEF VSNET}System.ComponentModel, System.Drawing, IWNETBaseControl,{$ENDIF}
  Classes,
  IWBaseControl, IWControl, IWHTMLTag, IWScriptEvents, IWRenderContext,
  IWBaseInterfaces, IWBaseHTMLControl;

type
  TIWCustomButton = class(TIWCustomControl, IIWSubmitControl)
  protected
    FSubmitParam : String;
    FButtonType: TIWButtonType;
    FHotKey: string;

    {$IFDEF VSNET}
    function getText: string; reintroduce;virtual;
    procedure setText(AValue: string); reintroduce;virtual;
    {$ENDIF}
    procedure Submit(const AValue: string); override;
    procedure HookEvents(APageContext: TIWPageContext40; AScriptEvents: TIWScriptEvents); override;
    procedure InitControl; override;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
    function GetSubmitParam : String;

    {$IFDEF VSNET}
    [DefaultValue(btButton)]
    {$ENDIF}
    property ButtonType: TIWButtonType read FButtonType write FButtonType default btButton;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property HotKey: string read FHotkey write FHotKey;
    {$IFDEF VSNET}
    property Text: string read getText write setText;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWButton.bmp}
  TIWButton = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWButton), 'TIWButton.bmp')]
  {$ENDIF}
  TIWButton = class(TIWCustomButton)
  published
    property ButtonType;

    {$IFDEF VSNET}
    property Text;
    {$ELSE}
    property Caption;
    {$ENDIF}

    property Confirmation;
    property DoSubmitValidation;

    property Enabled;
    property ExtraTagParams;
    {$IFDEF CLR}
    property WebColor;
    property WebFont;
    {$ELSE}
    property Color;
    property Font;
    {$ENDIF}
    property FriendlyName;
    property HotKey;
    property ScriptEvents;
    property TabOrder;

    property OnClick;
  end;

implementation

uses
  {$IFDEF VSNET}
  {$ELSE}
    {$IFNDEF Linux}Windows, {$ENDIF}
  {$ENDIF}
  {$IFDEF Linux}QGraphics, {$ELSE}Graphics, {$ENDIF}
  SysUtils, Math,
  IWColor, SWSystem;

{$IFDEF VSNET}
function TIWCustomButton.getText: string;
begin
  Result := Caption;
end;

procedure TIWCustomButton.setText(AValue: string);
begin
  Caption := AValue;
  TIWNETBaseControl(Self).Invalidate;
end;
{$ENDIF}

function TIWCustomButton.GetSubmitParam: String;
begin
  Result := FSubmitParam;
end;

function TIWCustomButton.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
  if FHotKey <> '' then begin
    Result := TIWHTMLTag.CreateTag('BUTTON'); try
      Result.AddStringParam('ACCESSKEY', FHotKey);
      Result.Contents.AddText(StringReplace(TextToHTML(Caption), FHotKey, '<u>' + FHotKey + '</u>', [rfIgnoreCase]));
    except FreeAndNil(result); raise; end;
  end else begin
    Result := TIWHTMLTag.CreateTag('INPUT'); try
      Result.AddStringParam('VALUE', TextToHTML(Caption));
    except FreeAndNil(Result); raise; end;
  end;
  try
    Result.AddStringParam('NAME', HTMLName);
    case ButtonType of
      btSubmit: Result.AddStringParam('TYPE', 'submit');
      btButton: Result.AddStringParam('TYPE', 'button');
      btReset: Result.AddStringParam('TYPE', 'reset');
    end;
    if (WebFont.Enabled) and (toTColor(WebColor) <> clBtnFace) then begin
      Result.AddStringParam('STYLE', 'background-color: ' + ColorToRGBString(WebColor)+ ';'
      + WebFont.FontToStringStyle(AContext.Browser));
    end; 
    if not Enabled then begin
      Result.Add('DISABLED');
    end;
  except FreeAndNil(Result); raise; end;
end; 

procedure TIWCustomButton.Submit(const AValue: string);
begin
  FSubmitParam := AValue;
  DoClick;
end;

procedure TIWCustomButton.InitControl;
begin
  inherited;
  WebColor := fromTCOlor(clBtnFace);
  FNeedsFormTag := True;
  FButtonType := btButton;
  set_RenderSize(true);
  Height := 25;
  Width := 75;
  FHotKey := '';
  FCanReceiveFocus := True;
end;

procedure TIWCustomButton.HookEvents(APageContext: TIWPageContext40; AScriptEvents: TIWScriptEvents);
begin
  inherited HookEvents(APageContext, AScriptEvents);
  AScriptEvents.HookEvent('OnClick', iif(hasOnClick or (ButtonType=btSubmit), SubmitHandler('')));
end;

end.
